//Learning Vector Quantization
//Windows 10
//Scilab 5.4.1
clear;
clc;

s=[1 1 0 0;0 0 0 1;0 0 1 1;1 0 0 0;0 1 1 0];
st=[1 2 2 1 2];
alpha=0.6;

//initial weight matrix first two vectors of input patterns
w=[s(1,:);s(2,:)]';
disp('Initial weight matrix');
disp(w);

//set remaining as input vector
x=[s(3,:);s(4,:);s(5,:)];
t=[st(3);st(4);st(5)];
con=1;
epoch=0;
while con
    for i=1:3
        for j=1:2
            D(j)=0;
            for k=1:4
                D(j)=D(j)+(w(k,j)-x(i,k))^2;
            end   
        end        
        for j=1:2
            if D(j)==min(D)
                J=j;
            end
        end
        if J==t(i)
            w(:,J)=w(:,J)+alpha*(x(i,:)'-w(:,J));
        else
            w(:,J)=w(:,J)-alpha*(x(i,:)'-w(:,J));
        end
        end
    alpha=0.5*alpha;
    epoch=epoch+1;
    if epoch==100
        con=0;
    end
end
disp('Weight Matrix after 100 epochs');
disp(w);

//Output
// Initial weight matrix
//
//   1.   0.
//   1.   0.
//   0.   0.
//   0.   1.
//
// Weight Matrix after 100 epochs
//
//   1.          0.       
//   0.2040471   0.561484 
//   0.          0.9583648
//   0.          0.438516 
